
DROP FUNCTION IF EXISTS factorial;
DROP FUNCTION IF EXISTS ventas_totales_fecha;
DROP FUNCTION IF EXISTS ventas_totales_periodo;
DROP FUNCTION IF EXISTS ventas_totales_cliente_periodo;

DELIMITER !!
CREATE FUNCTION factorial(n INTEGER)
RETURNS INTEGER
BEGIN
	DECLARE i,F integer;
	SET F=n;
	SET i=n-1;
	WHILE (i>0 AND i<=n) DO
		SET F=F*i;
		SET i=i-1;
	END WHILE;
	RETURN F;
END;


CREATE FUNCTION ventas_totales_fecha(p_fecha DATE)
RETURNS FLOAT
BEGIN
	DECLARE v_total FLOAT;
	SELECT SUM(cantidad*precio_venta) INTO v_total
	FROM detalle_venta INNER JOIN venta
	ON detalle_venta.folio_venta=venta.folio_venta
	WHERE venta.fecha=p_fecha; 
	RETURN v_total;
END;

CREATE FUNCTION ventas_totales_periodo(p_fecha_inicio DATE, p_fecha_fin DATE )
RETURNS FLOAT
BEGIN
	DECLARE v_total FLOAT;
	SELECT SUM(cantidad*precio_venta) INTO v_total
	FROM detalle_venta INNER JOIN venta
	ON detalle_venta.folio_venta=venta.folio_venta
	WHERE venta.fecha BETWEEN p_fecha_inicio AND p_fecha_fin; 
	RETURN v_total;
END;

CREATE FUNCTION ventas_totales_cliente_periodo(p_RFC varchar(30), p_fecha_inicio DATE, p_fecha_fin DATE )
RETURNS FLOAT
BEGIN
	DECLARE v_total FLOAT;
	SELECT SUM(cantidad*precio_venta) INTO v_total
	FROM detalle_venta INNER JOIN venta ON detalle_venta.folio_venta=venta.folio_venta
	INNER JOIN factura ON venta.folio_venta=factura.folio_venta
	WHERE factura.RFC=p_RFC and venta.fecha BETWEEN p_fecha_inicio AND p_fecha_fin; 
	RETURN v_total;
END;

DELIMITER ;
