-- Los triggers almacenados no se pueden modificar ni sobreescribir
-- es necesario borrarlos y volverlos a crear 

DROP TRIGGER IF EXISTS fecha_venta_nueva;
DROP TRIGGER IF EXISTS fecha_venta_modificar;
DROP TRIGGER IF EXISTS detalle_venta_procesa;

-- No olvidemos cambiar el caracter de fin de sentencia antes y después de crear los triggers

DELIMITER !! 	

CREATE TRIGGER fecha_venta_nueva                 /* Se crea el trigger con un nombre distinto a cualquier tabla o programa en la bd */
BEFORE INSERT ON venta							 /* Se elige el evento específico ANTES de INSERTAR en la tala venta */
FOR EACH ROW                                     /* Parte de la sintaxis y sirve por si se insertarán varios registros a la vez */
BEGIN											 /* Inicio de bloque PL/SQL */
	IF NEW.fecha<>current_date() THEN            /* Se pregunta si la nueva fecha NEW.fecha de venta que se pretende insertar es distinta a la fecha actual */
	   SET NEW.fecha=current_date();			 /* Si es así se asigna arbitrariamente a NEW.fecha la fecha actual */
	END IF;                                      /* Fin de la estructura IF */
END;

CREATE TRIGGER fecha_venta_modificar
BEFORE UPDATE ON venta							 /* Se elige el evento específico ANTES de MODIFICAR en la tabla venta */
FOR EACH ROW
BEGIN
	IF OLD.fecha<>NEW.fecha THEN                 /* Se pregunta si la fecha NEW.fecha es distinta a la fecha almacenada en la tabla OLD.fecha */
	   SET NEW.fecha=OLD.fecha;					 /* Si es así se asigna arbitrariamente la fecha nueva el valor de la fecha anterior, es decir que se regesa a su valor original */
	END IF;
END;


CREATE TRIGGER detalle_venta_procesa       
BEFORE INSERT ON detalle_venta			 /* Evento ANTES de INSERTAR en la tabla detalle_venta */
FOR EACH ROW                                     
BEGIN		
	DECLARE v_existencia INTEGER;         /* Variable local para guardar la existencia del producto a vender */
	DECLARE v_precio_actual FLOAT;		 /* Variable local para guardar el precio actual del producto a vender */
										 /* Consulta la existencia del producto y la guarda en v_existencia */
	SELECT existencia,precio_actual 
	INTO v_existencia,v_precio_actual      
	FROM producto
	WHERE codigo=NEW.codigo;					
	
	IF v_existencia=0 THEN               /* Si ya no hay producto no se permite la venta y se manda mensaje */
		SIGNAL SQLSTATE '45000' 
		SET message_text='Nada que vender';
	ELSE
		IF v_existencia<NEW.cantidad THEN    /* Si hay producto pero no el suficiente para la venta solicitada */
		   SET NEW.cantidad=v_existencia;    /* Se vende solo el producto en existencia */
		END IF;  
		
	    UPDATE producto
	    SET existencia=existencia-NEW.cantidad
	    WHERE codigo=NEW.codigo; /* Se descuenta el producto del inventario */
	   
	    SET NEW.precio_venta=v_precio_actual;   /* Se guarda el precio de venta consultado de la tabla de productos*/
	
	END IF;
END;

DELIMITER ;

