DROP TABLE IF EXISTS cliente;
CREATE TABLE cliente (
  RFC VARCHAR(30) NOT NULL,
  nombre VARCHAR(45) NOT NULL,
  domicilio VARCHAR(45) NOT NULL,
  telefono VARCHAR(20) NOT NULL,
  PRIMARY KEY (RFC));

DROP TABLE IF EXISTS venta;
CREATE TABLE venta (
  folio_venta INT NOT NULL AUTO_INCREMENT,
  fecha DATE  NOT NULL,
  PRIMARY KEY (folio_venta));

DROP TABLE IF EXISTS producto;
CREATE TABLE producto (
  codigo VARCHAR(20) NOT NULL,
  decripcion VARCHAR(45) NOT NULL,
  precio_actual FLOAT NOT NULL,
  existencia INT NOT NULL,
  PRIMARY KEY (codigo));

DROP TABLE IF EXISTS detalle_venta;
CREATE TABLE detalle_venta (
  codigo VARCHAR(20) NOT NULL,
  folio_venta INT NOT NULL,
  cantidad INT NOT NULL,
  precio_venta FLOAT NOT NULL,
  PRIMARY KEY (codigo, folio_venta),
  FOREIGN KEY (codigo) REFERENCES producto (codigo),
  FOREIGN KEY (folio_venta) REFERENCES venta (folio_venta));

DROP TABLE IF EXISTS factura;
CREATE TABLE  factura (
  folio_factura VARCHAR(50) NOT NULL,
  RFC VARCHAR(30) NOT NULL,
  folio_venta INT NOT NULL,
  PRIMARY KEY (folio_factura),
  FOREIGN KEY (RFC) REFERENCES cliente (RFC),
  FOREIGN KEY (folio_venta) REFERENCES venta (folio_venta));

