
CREATE VIEW vista_productos_vendidos AS
SELECT producto.codigo, decripcion,
       sum(cantidad) as cantidad_vendida, 
	   sum(cantidad*precio_venta) importe_vendido
FROM producto INNER JOIN detalle_venta
ON producto.codigo=detalle_venta.codigo	   
GROUP BY producto.codigo, decripcion;	   

DROP VIEW IF EXISTS vista_inventario_productos;
CREATE VIEW vista_inventario_productos AS
SELECT codigo, decripcion, precio_actual,
       sum(existencia) as existencia_inventario, 
	   sum(existencia*precio_actual) importe_inventario
FROM producto
GROUP BY codigo, decripcion; 


DROP VIEW IF EXISTS vista_total_venta;
CREATE VIEW vista_total_venta AS
SELECT folio_venta, 
       sum(cantidad*precio_venta) as total_venta
FROM detalle_venta
GROUP BY folio_venta;	   

DROP VIEW IF EXISTS vista_total_venta_factura;
CREATE VIEW vista_total_venta_factura AS
SELECT vista_total_venta.folio_venta,vista_total_venta.total_venta, 
       venta.fecha, factura.folio_factura, factura.RFC, 
	   cliente.nombre, cliente.domicilio,cliente.telefono
       FROM vista_total_venta 
	   LEFT JOIN venta ON vista_total_venta.folio_venta=venta.folio_venta
	   LEFT JOIN factura ON venta.folio_venta=factura.folio_venta
	   LEFT JOIN cliente ON factura.RFC=cliente.RFC;     

