
-- Se agregan algunos productos para poder vender

insert into producto values('p1','cuaderno',25.5,100);
insert into producto values('p2','lapiz',5.2,200);
insert into producto values('p3','borrador',3.5,50);
insert into producto values('p4','pluma',15.0,150);
insert into producto values('p5','carpeta',50.0,20);

-- En cualquier momento se puede consultar la instancia de la base de datos

select * from producto;

-- Se hacen algunas ventas, solo se da el valor de fecha en venta porque el folio se autoincrementa
-- current_date regresa la fecha del servidor
-- last_insert_id() regresa el último valor que tomó el autoincremento

insert into venta(fecha) values(current_date);  
insert into detalle_venta values('p3', last_insert_id(),2,(select precio_actual from producto where codigo='p3'));  
insert into detalle_venta values('p5', last_insert_id(),1,(select precio_actual from producto where codigo='p5'));
insert into detalle_venta values('p1', last_insert_id(),5,(select precio_actual from producto where codigo='p1'));

select * from venta;
select * from detalle_venta;

-- Se actualiza la existencia de los productos vendidos (Por el momento no se valida su existencia para la venta)

update producto set existencia=existencia-2 where codigo='p3';
update producto set existencia=existencia-1 where codigo='p5';
update producto set existencia=existencia-5 where codigo='p1';

select * from producto;

-- Se hace otra venta

insert into venta(fecha) values(current_date); 
insert into detalle_venta values('p1', last_insert_id(),5,(select precio_actual from producto where codigo='p1'));  
insert into detalle_venta values('p4', last_insert_id(),3,(select precio_actual from producto where codigo='p4'));

select * from venta;
select * from detalle_venta;

update producto set existencia=existencia-5 where codigo='p1';
update producto set existencia=existencia-3 where codigo='p4';

select * from producto;


-- Se agrega un cliente para facturar
-- Se le piden al clente sus datos incluyendo su RFC

insert into cliente values('ABCD121212HH1','IGNACIO RAMIREZ CORRAL','OTAY TECNOLOGICO','12345');

select * from cliente;

-- Se factura al cliente una de las ventas (se le pide al cliente su nota de venta para saber el folio de la misma)
-- Supongamos que el cliente muestre que su venta tiene el folio 2

insert into factura values('F00001','ABCD121212HH1',2);

select * from factura;

-- Se consultan las tablas para su revisión únicamente

